	TITLE	'MDBS CALL INTERFACE TYPE 01 PROGRAM'
;PROGRAM
;		MDBS CALL INTERFACE TYPE 01 PROGRAM
;PROGRAMMER
;		ROBERT M. WHITE
;DATE WRITTEN
;		AUGUST 27, 1980
;(C)COPYRIGHT	1980,H & W COMPUTER SYSTEMS, INC.
;PURPOSE
;		THIS ROUTINE INTERFACES FOR ALL MDBS CALLS THAT
;		LOOK LIKE THE FOLLOWING IN PLI:
;			CALL XXX(PARM1,RTNCODE);
;		WHERE PARM1 IS THE HL PARM.
;REMARKS
;		THIS MODULE CONTAINS SEVERAL ENTRY POINTS
;		WHICH CORRESPOND THE TO THE MDBS FUNCTION
;		NAME BEING CALLED.

;		DO INITIALIZATION.
	NAME	'MDBS01'
MDBS01:	CSEG

;		FFM - FIND FIRST MEMBER
FFM:	DS	0
	PUBLIC	FFM
	MVI	A,12		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FLM - FIND LAST MEMBER.
FLM:	DS	0
	PUBLIC	FLM
	MVI	A,16		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FLO - FIND LAST OWNER.
FLO:	DS	0
	PUBLIC	FLO
	MVI	A,17		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FNM - FIND NEXT MEMBER
FNM:	DS	0
	PUBLIC	FNM
	MVI	A,19		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FNO - FIND NEXT OWNER.
FNO:	DS	0
	PUBLIC	FNO
	MVI	A,20		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FPM - FIND PREVIOUS MEMBER.
FPM:	DS	0
	PUBLIC	FPM
	MVI	A,22		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		FPO - FIND PREVIOUS OWNER.
FPO:	DS	0
	PUBLIC	FPO
	MVI	A,23		;GET FUNCTION CODE.
	JMP	MAIN		;PROCESS CALL.

;		SAVE THE FUNCTION CODE.
MAIN:
	STA	FUNC

;		MOVE INPUT PARMS INTO OUTPUT PARM LIST.
	MOV	E,M		;GET FIRST PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM4
	XCHG
	MOV	E,M		;GET SECOND PARM.
	INX	H
	MOV	D,M
	INX	H
	XCHG			;SAVE IT.
	SHLD	PRM5

;		CALL THE MDBS CALL INTERFACE.
	LXI	H,PRMLST	;POINT TO PARAMETER LIST.
	JMP	MDBSCL		;GO PERFORM THE FUNCTION.
	EXTRN	MDBSCL
	PAGE
;****************************************************************
;*			PROGRAM CONSTANTS			*
;****************************************************************

;		INPUT PARM.
	DSEG
PRMLST:				;PL/1 PARAMETER LIST
PRM1:	DW	FUNC			;FUNCTION CODE
PRM2:	DW	NULCL8			;BC PARM
PRM3:	DW	NULCL8			;DE PARM
PRM4:	DW	0			;HL PARM
PRM5:	DW	0			;RETURN CODE
PRM6:	DW	NULPTR			;BLOCK PTR
PRM7:	DW	NULB15			;BLOCK LENGTH
FUNC:	DB	0
NULCL8:	DB	'        '
NULPTR:	DW	0
NULB15:	DW	0
	END
